// mstw.java
// demonstracja minimalnego drzewa rozpinajcego dla grafw waonych
// aby uruchomi program: C:>java MSTWApp (wersja angielska)
// aby skompilowa wersj polsk: C:>javac mstw.java
// po kompilacji:         C:>java MSTWApp
////////////////////////////////////////////////////////////////
class Edge
   {
   public int srcVert;   // indeks pocztkowego wierzchoka krawdzi
   public int destVert;  // indeks kocowego wierzchoka krawdzi
   public int distance;  // odlego midzy wierzchokami
// -------------------------------------------------------------
   public Edge(int sv, int dv, int d)  // konstruktor
      {
      srcVert = sv;
      destVert = dv;
      distance = d;
      }
// -------------------------------------------------------------
}  // end class Edge
////////////////////////////////////////////////////////////////
class PriorityQ
   {
   // tablica posortowana, od maksimum w 0 do minimum w size-1
   private final int SIZE = 20;
   private Edge[] queArray;
   private int size;
// -------------------------------------------------------------
   public PriorityQ()            // konstruktor
      {
      queArray = new Edge[SIZE];
      size = 0;
      }
// -------------------------------------------------------------
   public void insert(Edge item)  // wstaw element na pozycji odpowiedniej dla porzdku sortowania
      {
      int j;

      for(j=0; j<size; j++)           // znajd miejsce do wstawienia
         if( item.distance >= queArray[j].distance )
            break;

      for(int k=size-1; k>=j; k--)    // przesu elementy
         queArray[k+1] = queArray[k];

      queArray[j] = item;             // wstaw element
      size++;
      }
// -------------------------------------------------------------
   public Edge removeMin()            // usu najmniejszy element
      { return queArray[--size]; }
// -------------------------------------------------------------
   public void removeN(int n)         // usu element n
      {
      for(int j=n; j<size-1; j++)     // przesu elementy
         queArray[j] = queArray[j+1];
      size--;
      }
// -------------------------------------------------------------
   public Edge peekMin()          // odczytaj najniszy element
      { return queArray[size-1]; }
// -------------------------------------------------------------
   public int size()              // zwr liczb elementw
      { return size; }
// -------------------------------------------------------------
   public boolean isEmpty()      // 'prawda', jeeli kolejka jest pusta
      { return (size==0); }
// -------------------------------------------------------------
   public Edge peekN(int n)      // odczytaj element n
      { return queArray[n]; }
// -------------------------------------------------------------
   public int find(int findDex)  // znajd element o okrelonej
      {                          // wartoci destVert
      for(int j=0; j<size; j++)
         if(queArray[j].destVert == findDex)
            return j;
      return -1;
      }
// -------------------------------------------------------------
   }  // end class PriorityQ
////////////////////////////////////////////////////////////////
class Vertex
   {
   public char label;        // etykieta (np. 'A')
   public boolean isInTree;
// -------------------------------------------------------------
   public Vertex(char lab)   // konstruktor
      {
      label = lab;
      isInTree = false;
      }
// -------------------------------------------------------------
   }  // end class Vertex
////////////////////////////////////////////////////////////////
class Graph
   {
   private final int MAX_VERTS = 20;
   private final int INFINITY = 1000000;
   private Vertex vertexList[]; // lista wierzchokw
   private int adjMat[][];      // matryca przylegania
   private int nVerts;          // bieca liczba wierzchokw
   private int currentVert;
   private PriorityQ thePQ;
   private int nTree;           // liczba wierzchokw drzewa
// -------------------------------------------------------------
   public Graph()               // konstruktor
      {
      vertexList = new Vertex[MAX_VERTS];
                                          // matryca przylegania
      adjMat = new int[MAX_VERTS][MAX_VERTS];
      nVerts = 0;
      for(int j=0; j<MAX_VERTS; j++)      // zerowanie matrycy
         for(int k=0; k<MAX_VERTS; k++)   //    przylegania
            adjMat[j][k] = INFINITY;
      thePQ = new PriorityQ();
      }  // end constructor
// -------------------------------------------------------------
   public void addVertex(char lab)
      {
      vertexList[nVerts++] = new Vertex(lab);
      }
// -------------------------------------------------------------
   public void addEdge(int start, int end, int weight)
      {
      adjMat[start][end] = weight;
      adjMat[end][start] = weight;
      }
// -------------------------------------------------------------
   public void displayVertex(int v)
      {
      System.out.print(vertexList[v].label);
      }
// -------------------------------------------------------------
   public void mstw()           // minimalne drzewo rozpinajce
      {
      currentVert = 0;          // rozpocznij od wierzchoka 0

      while(nTree < nVerts-1)   // dopki nie wszystkie wierzchoki w drzewie
         {                      // zapisz w drzewie wierzchoek biecy
         vertexList[currentVert].isInTree = true;
         nTree++;

         // wstaw krawdzie przylegajce do biecego wierzchoka w kolejce
         for(int j=0; j<nVerts; j++)   // dla kadego wierzchoka,
            {
            if(j==currentVert)         // pomi, jeeli to biecy
               continue;
            if(vertexList[j].isInTree) // pomi, jeeli jest w drzewie
               continue;
            int distance = adjMat[currentVert][j];
            if( distance == INFINITY)  // pomi, jeeli nie ma krawdzi
               continue;
            putInPQ(j, distance);      // zapisz w kolejce (moe)
            }
         if(thePQ.size()==0)           // brak wierzchokw w kolejce?
               {
               System.out.println(" GRAF NIE JEST SPJNY");
               return;
               }
         // usu z kolejki krawd o najmniejszej odlegoci
         Edge theEdge = thePQ.removeMin();
         int sourceVert = theEdge.srcVert;
         currentVert = theEdge.destVert;

         // wywietl krawd od wierzchoka rdowego do wierzchoka biecego
         System.out.print( vertexList[sourceVert].label );
         System.out.print( vertexList[currentVert].label );
         System.out.print(" ");
         }  // end while (nie wszystkie wierzchoki w drzewie)

      // procedura MST zakoczona
      for(int j=0; j<nVerts; j++)     // usu oznaczenia wierzchokw
         vertexList[j].isInTree = false;
      }  // end mstw
// -------------------------------------------------------------
   public void putInPQ(int newVert, int newDist)
      {
      // czy jest inna krawd z tym samym wierzchokiem docelowym?
      int queueIndex = thePQ.find(newVert);
      if(queueIndex != -1)              // mamy indeks krawdzi
         {
         Edge tempEdge = thePQ.peekN(queueIndex);  // mamy krawd
         int oldDist = tempEdge.distance;
         if(oldDist > newDist)          // jeeli nowa krawd jest krtsza,
            {
            thePQ.removeN(queueIndex);  // usu poprzedni krawd
            Edge theEdge =
                        new Edge(currentVert, newVert, newDist);
            thePQ.insert(theEdge);      // wstaw now krawd
            }
         // w innym przypadku nie rb nic; pozostaw wczeniejszy wierzchoek na miejscu
         }  // end if
      else  // nie ma krawdzi o tym samym wierzchoku docelowym
         {                              // wic wstaw now
         Edge theEdge = new Edge(currentVert, newVert, newDist);
         thePQ.insert(theEdge);
         }
      }  // end putInPQ()
// -------------------------------------------------------------
   }  // end class Graph
////////////////////////////////////////////////////////////////
class MSTWApp
   {
   public static void main(String[] args)
      {
      Graph theGraph = new Graph();
      theGraph.addVertex('A');    // 0  (pocztek procedury MST)
      theGraph.addVertex('B');    // 1
      theGraph.addVertex('C');    // 2
      theGraph.addVertex('D');    // 3
      theGraph.addVertex('E');    // 4
      theGraph.addVertex('F');    // 5

      theGraph.addEdge(0, 1, 6);  // AB  6
      theGraph.addEdge(0, 3, 4);  // AD  4
      theGraph.addEdge(1, 2, 10); // BC 10
      theGraph.addEdge(1, 3, 7);  // BD  7
      theGraph.addEdge(1, 4, 7);  // BE  7
      theGraph.addEdge(2, 3, 8);  // CD  8
      theGraph.addEdge(2, 4, 5);  // CE  5
      theGraph.addEdge(2, 5, 6);  // CF  6
      theGraph.addEdge(3, 4, 12); // DE 12
      theGraph.addEdge(4, 5, 7);  // EF  7

      System.out.print("Minimalne drzewo rozpinajce: ");
      theGraph.mstw();            // minimalne drzewo rozpinajce
      System.out.println();
      }  // end main()
   }  // end class MSTWApp
////////////////////////////////////////////////////////////////

